/*
 * Decompiled with CFR 0.152.
 */
package com.awamenu.listeners;

import com.awamenu.AWAmenu;
import com.awamenu.models.Menu;
import com.awamenu.models.MenuItem;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class MenuListener
implements Listener {
    private AWAmenu plugin;

    public MenuListener(AWAmenu plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof Menu)) {
            return;
        }
        Menu menu = (Menu)holder;
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= inventory.getSize()) {
            return;
        }
        MenuItem menuItem = menu.getItem(slot);
        if (menuItem == null) {
            return;
        }
        for (String command : menuItem.getCommands()) {
            if (command.startsWith("awamenu")) {
                String[] parts = command.split(" ");
                if (parts.length > 1) {
                    this.plugin.getMenuManager().openMenu(player, parts[1]);
                    continue;
                }
                this.plugin.getMenuManager().openDefaultMenu(player);
                continue;
            }
            String processedCommand = command.replace("{player}", player.getName());
            if (processedCommand.startsWith("console:")) {
                String consoleCommand = processedCommand.substring(8).trim();
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), consoleCommand);
                continue;
            }
            if (processedCommand.startsWith("player:")) {
                String playerCommand = processedCommand.substring(7).trim();
                player.performCommand(playerCommand);
                continue;
            }
            player.performCommand(processedCommand);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof Menu) {
            Player player = (Player)event.getPlayer();
        }
    }
}

