/*
 * Decompiled with CFR 0.152.
 */
package com.awamenu.managers;

import com.awamenu.models.Menu;
import com.awamenu.models.MenuItem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private JavaPlugin plugin;
    private FileConfiguration config;
    private File configFile;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        if (!this.configFile.exists()) {
            plugin.saveResource("config.yml", false);
        }
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getDefaultMenu() {
        return this.config.getString("settings.default-menu", "main");
    }

    public boolean isAnimationsEnabled() {
        return this.config.getBoolean("settings.enable-animations", true);
    }

    public String getOpenSound() {
        return this.config.getString("settings.open-sound", "BLOCK_NOTE_BLOCK_PLING");
    }

    public String getCloseSound() {
        return this.config.getString("settings.close-sound", "BLOCK_NOTE_BLOCK_BASS");
    }

    public Map<String, Menu> loadMenus() {
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        if (!this.config.contains("menus")) {
            this.plugin.getLogger().warning("\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709\u627e\u5230\u83dc\u5355\u914d\u7f6e!");
            return menus;
        }
        for (String menuName : this.config.getConfigurationSection("menus").getKeys(false)) {
            String path = "menus." + menuName;
            String title = this.config.getString(path + ".title", "&6\u83dc\u5355");
            int size = this.config.getInt(path + ".size", 27);
            Menu menu = new Menu(menuName, title, size);
            if (this.config.contains(path + ".items")) {
                for (String slotStr : this.config.getConfigurationSection(path + ".items").getKeys(false)) {
                    try {
                        int slot = Integer.parseInt(slotStr);
                        String itemPath = path + ".items." + slotStr;
                        Material material = Material.matchMaterial((String)this.config.getString(itemPath + ".material", "STONE"));
                        if (material == null) {
                            material = Material.STONE;
                        }
                        String name = this.config.getString(itemPath + ".name", "\u672a\u547d\u540d\u7269\u54c1");
                        List lore = this.config.getStringList(itemPath + ".lore");
                        List commands = this.config.getStringList(itemPath + ".commands");
                        MenuItem menuItem = new MenuItem(material, name, lore, commands, slot);
                        menu.addItem(slot, menuItem);
                    }
                    catch (NumberFormatException e) {
                        this.plugin.getLogger().warning("\u65e0\u6548\u7684\u69fd\u4f4d\u7f16\u53f7: " + slotStr);
                    }
                }
            }
            menus.put(menuName, menu);
        }
        return menus;
    }

    public String getMessage(String key) {
        return this.config.getString("messages." + key, "&c\u6d88\u606f\u672a\u914d\u7f6e: " + key).replace('&', '\u00a7');
    }
}

