/*
 * Decompiled with CFR 0.152.
 */
package com.awamenu.managers;

import com.awamenu.managers.ConfigManager;
import com.awamenu.models.Menu;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MenuManager {
    private JavaPlugin plugin;
    private ConfigManager configManager;
    private Map<String, Menu> menus;

    public MenuManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configManager = new ConfigManager(plugin);
        this.menus = new HashMap<String, Menu>();
        this.loadMenus();
    }

    public void loadMenus() {
        this.menus = this.configManager.loadMenus();
        this.plugin.getLogger().info("\u5df2\u52a0\u8f7d " + this.menus.size() + " \u4e2a\u83dc\u5355");
    }

    public void openMenu(Player player, String menuName) {
        Menu menu = this.menus.get(menuName);
        if (menu == null) {
            player.sendMessage(this.configManager.getMessage("menu-not-found"));
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)this.configManager.getOpenSound());
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("\u65e0\u6548\u7684\u97f3\u6548\u914d\u7f6e: " + this.configManager.getOpenSound());
        }
        player.openInventory(menu.getInventory());
        player.sendMessage(this.configManager.getMessage("menu-opened"));
    }

    public void openDefaultMenu(Player player) {
        String defaultMenu = this.configManager.getDefaultMenu();
        this.openMenu(player, defaultMenu);
    }

    public boolean menuExists(String menuName) {
        return this.menus.containsKey(menuName);
    }

    public Menu getMenu(String menuName) {
        return this.menus.get(menuName);
    }

    public Map<String, Menu> getMenus() {
        return new HashMap<String, Menu>(this.menus);
    }

    public void reload() {
        this.configManager.reloadConfig();
        this.loadMenus();
    }
}

