/*
 * Decompiled with CFR 0.152.
 */
package com.awamenu.models;

import com.awamenu.models.MenuItem;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class Menu
implements InventoryHolder {
    private String name;
    private String title;
    private int size;
    private Map<Integer, MenuItem> items;

    public Menu(String name, String title, int size) {
        this.name = name;
        this.title = title;
        this.size = size;
        this.items = new HashMap<Integer, MenuItem>();
    }

    public void addItem(int slot, MenuItem item) {
        this.items.put(slot, item);
    }

    public MenuItem getItem(int slot) {
        return this.items.get(slot);
    }

    public void removeItem(int slot) {
        this.items.remove(slot);
    }

    public Inventory getInventory() {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)this.title.replace('&', '\u00a7'));
        for (Map.Entry<Integer, MenuItem> entry : this.items.entrySet()) {
            int slot = entry.getKey();
            MenuItem menuItem = entry.getValue();
            if (slot < 0 || slot >= this.size) continue;
            inventory.setItem(slot, menuItem.toItemStack());
        }
        return inventory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Map<Integer, MenuItem> getItems() {
        return this.items;
    }

    public void setItems(Map<Integer, MenuItem> items) {
        this.items = items;
    }
}

