/*
 * Decompiled with CFR 0.152.
 */
package com.awamenu.models;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuItem {
    private Material material;
    private String name;
    private List<String> lore;
    private List<String> commands;
    private int slot;

    public MenuItem(Material material, String name, List<String> lore, List<String> commands, int slot) {
        this.material = material;
        this.name = name;
        this.lore = lore != null ? lore : new ArrayList();
        this.commands = commands != null ? commands : new ArrayList();
        this.slot = slot;
    }

    public ItemStack toItemStack() {
        ItemStack item = new ItemStack(this.material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (this.name != null) {
                meta.setDisplayName(this.name.replace('&', '\u00a7'));
            }
            if (!this.lore.isEmpty()) {
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : this.lore) {
                    coloredLore.add(line.replace('&', '\u00a7'));
                }
                meta.setLore(coloredLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }
}

